from typing import List

from aiopg.sa import Engine
from sqlalchemy.dialects.postgresql import insert

from mail.python.theatre.roles import Cron
from mail.python.theatre.stages.bucket_holder.interactions.db.meta import BucketsMetainfo
from mail.python.theatre.stages.bucket_holder.interactions.db.db_engine import DbEngine
from mail.samsara.samsara.settings.buckets_provider import BucketsProviderSettings


class BucketsProvider(Cron):
    def __init__(self, huskydb_pg: Engine, meta: BucketsMetainfo, settings: BucketsProviderSettings):
        super(BucketsProvider, self).__init__(job=self.update_shards_in_samsara, **settings.cron.as_dict())
        self._pg = DbEngine(huskydb_pg)
        self._meta = meta

    async def update_shards_in_samsara(self):
        async with self._pg.acquire() as conn:
            shard_ids = [
                row['shard_id'] async for row in conn.execute('SELECT shard_id FROM shiva.shards')
            ]
            await conn.execute(self.update_buckets_sql(shard_ids))

    def update_buckets_sql(self, shard_ids: List[int]):
        # TODO :: Remove buckets with deleted shard_ids
        return (
            insert(self._meta.t_buckets)
            .values([
                {self._meta.t_buckets.c_id: shard_id}
                for shard_id in shard_ids
            ])
            .on_conflict_do_nothing()
        )
