import requests

from mail.python.theatre.stages.db_stats.types import DbHost, Db


def get_shard_by_id(sharpei_host, shard_id):
    resp = requests.get(f'{sharpei_host}/v3/stat')
    if resp.status_code != 200:
        raise RuntimeError(f'Sharpei responds {resp.status_code}')
    resp_json = resp.json()
    if str(shard_id) not in resp_json:
        raise RuntimeError(f'shard_id={shard_id} not found in /stat response: {resp_json}')
    return resp_json[str(shard_id)]


def make_dsn(addr, user):
    return 'host={host} port={port} dbname={dbname} user={user}'.format(user=user, **addr)


def get_shard(sharpei_host, shard_id, user='maildb'):
    shard = get_shard_by_id(sharpei_host, shard_id)
    return Db(
        hosts=[
            DbHost(
                dsn=make_dsn(addr=host['address'], user=user),
                geo=host['address']['dataCenter'],
                primary=host['role'] == 'master',
            )
            for host in shard["databases"]
        ],
        ctype=shard['name'],
    )
