package ru.yandex.aceventura.search.backend;

import java.text.ParseException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

import org.apache.lucene.util.StringHelper;

import ru.yandex.msearch.collector.FieldToIndex;
import ru.yandex.msearch.collector.YaDoc3;
import ru.yandex.msearch.collector.YaField;
import ru.yandex.msearch.collector.docprocessor.DocProcessor;
import ru.yandex.msearch.collector.docprocessor.ModuleFieldsAggregator;

public class DepartmentDistanceDocProcessor implements DocProcessor {
    private static final int DEFAULT_DIST = 100;
    private static final int ROBOT_PENALTY = 12;
    private static final String ROBOT_DEP = "8174";
    private final String field;
    private final String outField;
    protected final int fieldIndex;
    protected final int outFieldIndex;
    protected final Map<String, Integer> dep;

    public DepartmentDistanceDocProcessor(
        final String args,
        final FieldToIndex fieldToIndex)
        throws ParseException
    {
        if (args == null || args.isEmpty()) {
            throw new ParseException("Arguments required", 0);
        }
        int space = args.indexOf(' ');
        int comma = args.indexOf(',');
        String field;
        String outField;

        if (space <= 0 || comma <= 0 || comma > space) {
            throw new ParseException(
                "Bad comma or space position in " + args,
                comma);
        }

        field = args.substring(0, comma);
        outField = args.substring(space + 1);

        this.field = StringHelper.intern(field);
        this.outField = StringHelper.intern(outField);
        fieldIndex = fieldToIndex.indexFor(this.field);
        outFieldIndex = fieldToIndex.indexFor(this.outField);
        String value = args.substring(comma + 1, space);
        if (value.isEmpty()) {
            dep = Collections.emptyMap();
        } else {
            String[] split = value.split(";");
            dep = new LinkedHashMap<>(split.length);
            for (int i = 0; i < split.length; i++) {
                dep.put(split[i], split.length - i - 1);
            }
        }
    }

    protected int calc(final String other) {
        if (other.isEmpty()) {
            return DEFAULT_DIST + dep.size();
        }

        boolean countLeft = false;
        int leftCost = 0;
        int rightCost = dep.size();

        int start = 0;
        String item;
        for (int i = 0; i < other.length(); i++) {
            char c = other.charAt(i);
            if (c == '\n') {
                item = other.substring(start, i);
                start = i + 1;
                if (!countLeft) {
                    Integer value = dep.get(item);
                    if (value == null) {
                        countLeft = true;
                    } else {
                        rightCost = value;
                    }
                }

                if (countLeft) {
                    if (ROBOT_DEP.equals(item)) {
                        leftCost += ROBOT_PENALTY;
                        break;
                    } else {
                        leftCost += 1;
                    }
                }
//
//                leftCost -= 1;
//                rightCost = value;
            }
        }

        if (start < other.length()) {
            item = other.substring(start);
            if (!countLeft) {
                Integer value = dep.get(item);
                if (value == null) {
                    countLeft = true;
                } else {
                    rightCost = value;
                }
            }

            if (countLeft) {
                if (ROBOT_DEP.equals(item)) {
                    leftCost += ROBOT_PENALTY;
                } else {
                    leftCost += 1;
                }
            }
        }
//        String[] split = other.split("\\n");
//        int leftCost = split.length;
//        int rightCost = dep.size();
//
//        for (String item: split) {
//            Integer value = dep.get(item);
//            if (value == null) {
//                return leftCost + rightCost;
//            }
//
//            leftCost -= 1;
//            rightCost = value;
//        }

        return rightCost + leftCost;
    }

    @Override
    public void apply(final ModuleFieldsAggregator aggregator) {
        aggregator.add(field, outField);
    }

    @Override
    public void process(final YaDoc3 doc) {
        YaField field = doc.getField(fieldIndex);
        int score;

        if (dep.size() == 0) {
            score = DEFAULT_DIST;
        } else {
            if (field != null) {
                score = calc(field.toString());
            } else {
                score = DEFAULT_DIST + dep.size();
            }
        }

        doc.setField(outFieldIndex, new YaField.IntegerYaField(score));
    }
}
