#!/bin/bash
set -exo pipefail

export TVM_API_HOST=https://tvm-api.yandex.net

export PS_ABCSERVICE="pssearch"
export PS_PROJECT="aceventura"
export PUSHCLIENT_DEFAULT_TOPIC="/$PS_ABCSERVICE/logs/${PS_PROJECT}-access-log"

case "$NANNY_SERVICE_ID" in
    *_prod | *_qa)
        export TVM_CLIENT_ID=2014088
        export TVM_ALLOWED_SRCS="$TVM_CLIENT_ID,2001063,2001570"
        export ACEVENTURA_QUEUE=aceventura_change_log_prod
        export PROXY_HOST=aceventura-proxy-prod.search.yandex.net
        export PRODUCER_HOST=aceventura-producer-common.n.yandex-team.ru
        export PRODUCER_SERVER_NAME=aceventura-producer-prod.search.yandex.net
        export PRODUCER_INDEXING_HOST=$PRODUCER_HOST
        export MSAL_HOST="http://msal.search.yandex.net:8080/"
        export BLACKBOX_CLIENT_ID=224
        ;;
    *_test)
        export TVM_CLIENT_ID=2014086
        #export MSAL_HOST="http://msal-tst.mail.yandex.net:8080/"
        export MSAL_HOST="vla2-0474-0b5-vla-mail-msal-test-18274.gencfg-c.yandex.net:8080"
        export BLACKBOX_CLIENT_ID=224
        export TVM_ALLOWED_SRCS="$TVM_CLIENT_ID,2001063,2001570"
        export ACEVENTURA_QUEUE=aceventura_change_log_test
        export PROXY_HOST=aceventura-proxy-test.search.yandex.net
        export PRODUCER_HOST=aceventura-producer-test.search.yandex.net
        export PRODUCER_SERVER_NAME=aceventura-producer-test.search.yandex.net
        export PRODUCER_INDEXING_HOST=$PRODUCER_HOST
esac

