package ru.yandex.ace.ventura;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;

public enum AceVenturaFields {
    /** COMMON **/
    ID("id", AceVenturaFieldAliasType.SIMPLE_UNPREFIXED, AceVenturaRecordType.values()),

    REVISION,
    CHANGE_TYPE,
    CHANGE_ID,
    CHANGE_DATE,
    RECORD_TYPE(AceVenturaFieldAliasType.PREFIXED_ALIAS),
    USER_ID,
    USER_TYPE,
    OWNER_ID(AceVenturaFieldAliasType.PREFIXED_ALIAS),
    OWNER_TYPE,

    /** CONTACT + EMAILS **/
    TAGS(AceVenturaRecordType.CONTACT, AceVenturaRecordType.EMAIL),
    SHARED(AceVenturaRecordType.CONTACT, AceVenturaRecordType.EMAIL),
    //SHARED_CLIENTS(AceVenturaRecordType.CONTACT, AceVenturaRecordType.EMAIL),

    /** CONTACT **/
    CONTACT_TAGS(AceVenturaRecordType.CONTACT),
    VCARD(AceVenturaRecordType.CONTACT),
    CID(AceVenturaFieldAliasType.PREFIXED_ALIAS, AceVenturaRecordType.CONTACT),
    NAMES(AceVenturaRecordType.CONTACT),
    EN_NAMES(AceVenturaRecordType.CONTACT),
    NAMES_ALIAS(AceVenturaRecordType.CONTACT),
    HAS_PHONES(AceVenturaRecordType.CONTACT),
    PHONES(AceVenturaRecordType.CONTACT),
    PHONES_N(AceVenturaRecordType.CONTACT),
    LIST_ID(AceVenturaRecordType.CONTACT),
    LIST_NAME(AceVenturaRecordType.CONTACT),
    LIST_TYPE(AceVenturaRecordType.CONTACT),
    FORMAT(AceVenturaRecordType.CONTACT),

    /** EMAILS **/
    EMAIL_TAGS(AceVenturaRecordType.EMAIL),
    EMAIL_TYPE(AceVenturaRecordType.EMAIL),
    EMAIL_LABEL(AceVenturaRecordType.EMAIL),
    EMAIL_CID(AceVenturaRecordType.EMAIL),
    LOGIN(AceVenturaRecordType.EMAIL),
    LOGIN_LETTER(AceVenturaRecordType.EMAIL),
    // all logins reformulations
    LOGINS(AceVenturaRecordType.EMAIL),
    LOGINS_LETTER(AceVenturaRecordType.EMAIL),
    DOMAIN(AceVenturaRecordType.EMAIL),
    DOMAIN_NT(AceVenturaRecordType.EMAIL),
    EMAIL("av_email", "av_email", "av_email_np", AceVenturaRecordType.EMAIL),
    EMAIL_NORMALIZED(AceVenturaRecordType.EMAIL),
    EMAIL_ID(AceVenturaRecordType.EMAIL),

    /** TAGS **/
    TAG_ID(AceVenturaRecordType.TAG),
    TAG_NAME(AceVenturaRecordType.TAG),
    TAG_NAME_LETTER(AceVenturaRecordType.TAG),
    TAG_TYPE(AceVenturaRecordType.TAG),

    /** SHARED **/
    SHARED_OWNER_UID(AceVenturaRecordType.SHARED),
    SHARED_OWNER_UTYPE(AceVenturaRecordType.SHARED),
    SHARED_LIST_ID(AceVenturaRecordType.SHARED),

    /** Feedback (chooses from suggest) **/
    LAST_REQUESTS,
    LAST_USAGE,
    LAST_USAGE_DAY(AceVenturaFieldAliasType.PREFIXED_ALIAS),

    /** staff populated fields **/
    CORP_DISMISSED,
    CORP_DEPARTMENTS,
    CORP_DEPARTMENT_ID,
    CORP_DEPARTMENT_LEVEL,
    CORP_POSITION_TYPE,
    CORP_POSITION_NAME,
    CORP_MESSENGERS_NICKS,
    IS_CORP(AceVenturaFieldAliasType.SIMPLE_UNPREFIXED);

    /** List of fields that we sync from contact to email record **/
    public static final Collection<AceVenturaFields> EMAIL_CONTACTS_FIELDS =
        Collections.unmodifiableList(
            Arrays.asList(
                AceVenturaFields.NAMES,
                AceVenturaFields.NAMES_ALIAS,
                AceVenturaFields.LIST_ID,
                AceVenturaFields.CONTACT_TAGS));

    @SuppressWarnings("ImmutableEnumChecker")
    private final Set<AceVenturaRecordType> types;
    private final String fieldName;
    private final String prefixedName;
    private final String globalName;

    AceVenturaFields(
        final String fieldName,
        final AceVenturaFieldAliasType aliasType,
        final AceVenturaRecordType... types)
    {
        if (fieldName == null) {
            this.fieldName = "av_" + name().toLowerCase(Locale.ENGLISH);
        } else {
            this.fieldName = fieldName;
        }

        switch (aliasType) {
            case SIMPLE_PREFIXED:
                this.prefixedName = this.fieldName;
                this.globalName = null;
                break;
            case SIMPLE_UNPREFIXED:
                this.prefixedName = null;
                this.globalName = this.fieldName;
                break;
            case PREFIXED_ALIAS:
                this.prefixedName = this.fieldName + "_p";
                this.globalName = this.fieldName;
                break;
            case NONPREFIXED_ALIAS:
                this.prefixedName = this.fieldName;
                this.globalName = this.fieldName + "_np";
                break;
            default:
                throw new IllegalArgumentException("Unsupported alias type " + aliasType);
        }

        this.types = Collections.unmodifiableSet(new LinkedHashSet<>(Arrays.asList(types)));
    }

    AceVenturaFields() {
        this(null, AceVenturaFieldAliasType.SIMPLE_PREFIXED, AceVenturaRecordType.values());
    }

    AceVenturaFields(final AceVenturaRecordType... types) {
        this(null, AceVenturaFieldAliasType.SIMPLE_PREFIXED, types);
    }

    AceVenturaFields(final AceVenturaFieldAliasType aliasType) {
        this(null, aliasType, AceVenturaRecordType.values());
    }

    AceVenturaFields(final AceVenturaFieldAliasType aliasType, final AceVenturaRecordType... types) {
        this(null, aliasType, types);
    }

    AceVenturaFields(
        final String storeField,
        final String prefixedField,
        final String globalField,
        final AceVenturaRecordType... types)
    {
        this.fieldName = storeField;
        this.prefixedName = prefixedField;
        this.globalName = globalField;
        this.types = Collections.unmodifiableSet(new LinkedHashSet<>(Arrays.asList(types)));
    }

    public boolean hasType(final AceVenturaRecordType type) {
        return types.contains(type);
    }

    public Set<AceVenturaRecordType> types() {
        return types;
    }

    public String field() {
        return fieldName;
    }

    public String prefixed() {
        checkNotNull(prefixedName);
        return prefixedName;
    }

    public String global() {
        checkNotNull(globalName);
        return globalName;
    }

    public String stored() {
        return fieldName;
    }

    void checkNotNull(final String field) {
        if (field == null) {
            throw new UnsupportedOperationException("Field " + field + " has no such alias");
        }
    }

    public static String contactUrl(
        final String id,
        final AceVenturaPrefix user,
        final AceVenturaPrefix owner)
    {
        if (!user.equals(owner)) {
            return "av_contact_"
                + user.uid()
                + '_' + user.userType().lowName()
                + '_' + owner.uid()
                + '_' + owner.userType().lowName()
                + '_' + id;
        } else {
            return "av_contact_"
                + user.uid()
                + '_' + user.userType().lowName()
                + '_' + id;
        }
    }

    public static String emailUrl(
        final String id,
        final AceVenturaPrefix user,
        final AceVenturaPrefix owner)
    {
        if (!user.equals(owner)) {
            return "av_email_"
                + user.uid()
                + '_' + user.userType().lowName()
                + '_' + owner.uid()
                + '_' + owner.userType().lowName()
                + '_' + id;
        } else {
            return "av_email_"
                + user.uid()
                + '_' + user.userType().lowName()
                + '_' + id;
        }
    }

    public static String tagUrl(
        final String id,
        final AceVenturaPrefix user)
    {
        return "av_tag_"
            + user.uid()
            + '_' + user.userType().lowName()
            + '_' + id;
    }

    public static String sharedUrl(
        final String id,
        final AceVenturaPrefix owner,
        final AceVenturaPrefix user)
    {
        return "av_share_"
            + user.uid()
            + '_' + user.userType().lowName()
            + '_' + owner.uid()
            + '_' + owner.userType().lowName()
            + '_' + id;
    }

    public static String corpStaffUrl(
        final AceVenturaPrefix user)
    {
        return "av_corp_staff_" + user.uid();
    }
}
