package ru.yandex.ace.ventura;

import java.util.Locale;

import ru.yandex.search.prefix.StringPrefix;

public class AceVenturaPrefix extends StringPrefix {
    public static final char SEPARATOR = '$';
    private static final int PREFIX_SIZE = 19 + 1 + 20;
    private final long uid;
    private final UserType userType;

    public AceVenturaPrefix(final long uid, final UserType userType) {
        super(buildPrefix(uid, userType).toString());
        this.uid = uid;
        this.userType = userType;
    }

    public long uid() {
        return uid;
    }

    public UserType userType() {
        return userType;
    }

    private static StringBuilder buildPrefix(
        final long uid,
        final UserType type)
    {
        StringBuilder prefix = new StringBuilder(PREFIX_SIZE);
        prefix.append(uid);
        prefix.append(SEPARATOR);
        prefix.append(type.name().toLowerCase(Locale.ROOT));
        return prefix;
    }

    public static AceVenturaPrefix parse(final String s) throws Exception {
        return new AceVenturaPrefixParser().apply(s);
    }
}
