package ru.yandex.ace.ventura;

import java.text.ParseException;

import ru.yandex.function.GenericFunction;
import ru.yandex.parser.string.EnumParser;

public class AceVenturaPrefixParser
    implements GenericFunction<String, AceVenturaPrefix, Exception>
{
    private static final String SEPARATOR = "\\" + AceVenturaPrefix.SEPARATOR;
    private final EnumParser<UserType> userTypeParser =
        new EnumParser<>(UserType.class);

    @Override
    public AceVenturaPrefix apply(final String s) throws Exception {
        String[] split = s.split(SEPARATOR);
        if (split.length != 2) {
            throw new ParseException(s + " invalid prefix split size " + split.length, -1);
        }

        long uid = Long.parseLong(split[0]);
        UserType userType = userTypeParser.apply(split[1].trim());
        return new AceVenturaPrefix(uid, userType);
    }
}
