package ru.yandex.ace.ventura;

import java.util.Locale;

public enum UserType {
    PASSPORT_USER("puser"),
    PASSPORT_DOMAIN("pdomain"),
    CONNECT_ORGANIZATION("cnnctorg");

    final String lowName;
    final String shortName;


    UserType(final String shortName) {
        this.shortName = shortName;
        this.lowName = name().toLowerCase(Locale.ROOT);
    }

    UserType() {
        lowName = name().toLowerCase(Locale.ROOT);
        shortName = lowName;
    }

    public String lowName() {
        return lowName;
    }

    public String shortName() {
        return shortName;
    }

    @Override
    public String toString() {
        return this.lowName;
    }
}
