#!/bin/bash
set -exo pipefail

source ace_proxy_config.sh
source classpath.sh

CORE_DIR="/coredumps"
export IBM_HEAPDUMP=1
export IBM_HEAP_DUMP=1
export IBM_COREDIR=$CORE_DIR
export IBM_HEAPDUMPDIR=$CORE_DIR
export IBM_JAVACOREDIR=$CORE_DIR
export LANG=en_US.UTF-8
export LD_LIBRARY_PATH=.

if [ "$MEM_LIMIT" != "" ]; then
    export MEMORY_LIMIT=$((MEM_LIMIT/100*80))
else
    export MEMORY_LIMIT=$(cat dump.json | jq -r '.container.constraints | .["slot.memory_limit"]' | awk '{print int($1*0.8)}')
fi

if [ "$MEMORY_LIMIT" = "0" ]; then
    export MEMORY_LIMIT=$(cat dump.json | jq -r '.container.constraints | .["memory_guarantee"]' | awk '{print int($1*0.8)}')
fi

XMX=$MEMORY_LIMIT
XMS=$((XMX / 4))

#XMX=$(jq -r '.container.constraints["memory_guarantee"]' $BSCONFIG_IDIR/dump.json | gawk '{print int($1 * 0.8 / 1048576)}')
#XMS=$((XMX / 4))
MEM_ARGS="-Xms${XMS} -Xmx${XMX}  -Xmn384M -Xmaxf0.4 -Xminf0.2 -Xmine256M -Xmaxe1G -Xmint0.03 -XX:ActiveProcessorCount=8"
GC_ARGS="-Xgcpolicy:balanced -verbose:gc -Xverbosegclog:/logs/gc#.log,10,10000"
DUMP_ARGS="-Xdump:system+heap+java:events=systhrow+user,filter=java/lang/OutOfMemoryError,request=exclusive+prepwalk+compact"
NET_ARGS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true"
exec $BSCONFIG_IDIR/jdk/bin/java \
    $MEM_ARGS $DUMP_ARGS $GC_ARGS $NET_ARGS \
    -Djava.library.path=aceventura_proxy \
    -DACEVENTURA_QUEUE=$ACEVENTURA_QUEUE \
    -cp $CLASSPATH \
    ru.yandex.ace.ventura.proxy.AceVenturaProxy \
    aceventura_proxy.conf

