package ru.yandex.ace.ventura.proxy;

import java.util.Locale;
import java.util.function.Supplier;
import java.util.logging.Logger;

import org.apache.http.client.protocol.HttpClientContext;

import ru.yandex.ace.ventura.AceVenturaConstants;
import ru.yandex.ace.ventura.AceVenturaPrefix;
import ru.yandex.ace.ventura.proxy.common.SharedScope;
import ru.yandex.blackbox.BlackboxUserinfo;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.nio.client.AbstractAsyncClient;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.parser.searchmap.User;
import ru.yandex.parser.uri.CgiParams;

public abstract class AbstractAceVenturaProxyContext
    implements AceVenturaProxyContext
{
    protected final ProxySession session;
    protected final JsonType jsonType;
    protected final AsyncClient client;
    protected final Supplier<? extends HttpClientContext> contextGenerator;
    protected final AceVenturaProxy proxy;
    protected final User user;

    protected final AceVenturaPrefix prefix;
    protected final Locale locale;

    protected final long lagTolerance;
    protected final boolean debug;
    protected final boolean corp;

    protected SharedScope shareScope;

    protected AbstractAceVenturaProxyContext(
        final AceVenturaProxy proxy,
        final ProxySession session)
        throws BadRequestException
    {
        this.proxy = proxy;
        this.session = session;

        CgiParams params = session.params();

        prefix = proxy.parsePrefix(params);
        corp = BlackboxUserinfo.corp(prefix.uid());

        jsonType = JsonTypeExtractor.NORMAL.extract(params);
        lagTolerance =
            params.getInt("lag-tolerance", 10);

        client = proxy.searchClient().adjust(session.context());
        contextGenerator =
            session.listener().createContextGeneratorFor(client);

        user = new User(AceVenturaConstants.ACEVENTURA_QUEUE, prefix);
        locale = params.getLocale("locale", Locale.ROOT);

        this.debug = params.getBoolean("debug", false);

        shareScope =
            params.getEnum(
                SharedScope.class,
                AceVenturaProxyParams.SHARED,
                SharedScope.EXCLUDE);
    }

    @Override
    public AceVenturaProxy proxy() {
        return proxy;
    }

    @Override
    public ProxySession session() {
        return session;
    }

    @Override
    public Supplier<? extends HttpClientContext> contextGenerator() {
        return contextGenerator;
    }

    @Override
    public JsonType jsonType() {
        return jsonType;
    }

    @Override
    public User user() {
        return user;
    }

    @Override
    public Long minPos() {
        return null;
    }

    @Override
    public AbstractAsyncClient<?> client() {
        return client;
    }

    @Override
    public Logger logger() {
        return session.logger();
    }

    @Override
    public long lagTolerance() {
        return lagTolerance;
    }

    @Override
    public Locale locale() {
        return locale;
    }

    @Override
    public AceVenturaPrefix prefix() {
        return prefix;
    }

    @Override
    public SharedScope shareScope() {
        return shareScope;
    }

    @Override
    public boolean debug() {
        return debug;
    }

    @Override
    public boolean corp() {
        return corp;
    }
}
