package ru.yandex.ace.ventura.proxy;

import java.util.Locale;
import java.util.function.Supplier;

import org.apache.http.client.protocol.HttpClientContext;

import ru.yandex.ace.ventura.AceVenturaPrefix;
import ru.yandex.ace.ventura.proxy.common.SharedScope;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.json.writer.JsonType;
import ru.yandex.search.proxy.universal.UniversalSearchProxyRequestContext;

public interface AceVenturaProxyContext
    extends UniversalSearchProxyRequestContext
{
    AceVenturaProxy proxy();

    ProxySession session();

    Supplier<? extends HttpClientContext> contextGenerator();

    JsonType jsonType();

    Long failOverDelay();

    SharedScope shareScope();

    int length();

    Locale locale();

    AceVenturaPrefix prefix();

    boolean debug();

    boolean corp();
}
