package ru.yandex.ace.ventura.proxy;

import java.util.LinkedHashSet;
import java.util.Set;

import ru.yandex.ace.ventura.AceVenturaPrefix;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.parser.searchmap.User;
import ru.yandex.parser.string.CollectionParser;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.uri.CgiParams;
import ru.yandex.search.rules.RequestParams;

public class AceVenturaRequestParams implements RequestParams {
    private static final CollectionParser<String, Set<String>, Exception>
        SET_PARSER =
        new CollectionParser<>(NonEmptyValidator.TRIMMED, LinkedHashSet::new);

    private final AceVenturaPrefix prefix;
    private final Set<String> fields;
    private final User user;
    private final ShareType shareType;
    private final int offset;
    private final int length;

    public AceVenturaRequestParams(
        final AceVenturaProxy proxy,
        final CgiParams params)
        throws BadRequestException
    {
        offset = params.getInt("offset", 0);
        length = params.getInt("limit");

        prefix = proxy.parsePrefix(params);
        user = new User("aceventura", prefix);
        fields = params.getAll("vcard_properties", SET_PARSER);
        shareType = params.getEnum(ShareType.class, "share");
    }

    public AceVenturaPrefix prefix() {
        return prefix;
    }

    @Override
    public Set<String> fields() {
        return fields;
    }

    public User user() {
        return user;
    }

    @Override
    public int offset() {
        return offset;
    }

    @Override
    public int length() {
        return length;
    }

    public ShareType shareType() {
        return shareType;
    }
}
