package ru.yandex.ace.ventura.proxy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

import org.apache.http.HttpException;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.http.util.MultiFutureCallback;
import ru.yandex.search.rules.pure.SearchRule;

public class ConcatRule<R, M extends AceVenturaProxyContext>
    implements SearchRule<M, Collection<R>>
{
    private final List<SearchRule<M, List<R>>> rules;

    public ConcatRule(
        final Collection<SearchRule<M, List<R>>> rules)
    {
        this.rules = new ArrayList<>(rules);
    }

    @Override
    public void execute(
        final M input,
        final FutureCallback<? super Collection<R>> callback)
        throws HttpException
    {
        MultiFutureCallback<List<R>> mfcb =
            new MultiFutureCallback<>(
                new Callback(input, callback));

        for (SearchRule<M, List<R>> rule: rules) {
            rule.execute(input, mfcb.newCallback());
        }

        mfcb.done();
    }

    private final class Callback
        extends AbstractFilterFutureCallback<List<List<R>>, Collection<R>>
    {
        private final M input;

        public Callback(
            final M input,
            final FutureCallback<? super Collection<R>> callback)
        {
            super(callback);

            this.input = input;
        }

        @Override
        public void completed(final List<List<R>> resp) {
            LinkedHashSet<R> result =
                new LinkedHashSet<>(resp.size() * input.length());
            Iterator<List<R>> iterator = resp.iterator();
            while (iterator.hasNext()) {
                result.addAll(iterator.next());
            }

            callback.completed(result);
        }
    }
}

