package ru.yandex.ace.ventura.proxy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.ace.ventura.proxy.common.AceVenturaContact;
import ru.yandex.ace.ventura.proxy.common.AceVenturaEmail;
import ru.yandex.http.util.AbstractFilterFutureCallback;

public class DeduplicateByEmailCallback<T extends AceVenturaProxyContext>
    extends AbstractFilterFutureCallback<List<Collection<AceVenturaContact>>, Collection<AceVenturaContact>>
{
    private final T input;
    private final Comparator<AceVenturaContact> comparator;

    public DeduplicateByEmailCallback(
        final T input,
        final Comparator<AceVenturaContact> comparator,
        final FutureCallback<? super Collection<AceVenturaContact>> callback)
    {
        super(callback);

        this.input = input;
        this.comparator = comparator;
    }

    protected boolean merge(final AceVenturaContact current, final AceVenturaContact newOne) {
        if (current.shared() ^ newOne.shared()) {
            return current.shared();
        } else {
            return newOne.lastUsage() > current.lastUsage();
        }
    }

    @Override
    public void completed(final List<Collection<AceVenturaContact>> resp) {
        LinkedHashMap<Set<String>, AceVenturaContact> emails
            = new LinkedHashMap<>(resp.size() * input.length());

        // map email <-> contact list, email
        // map
//            Map<String, List<AceVenturaContact>> emails =
//                new LinkedHashMap<>(resp.size() * input.length());

        for (Collection<AceVenturaContact> collection: resp) {
            for (AceVenturaContact contact: collection) {
                Set<String> emailsKeys = new LinkedHashSet<>(contact.emails().size());
                for (AceVenturaEmail email: contact.emails()) {
                    emailsKeys.add(email.email());
                }

                AceVenturaContact current = emails.get(emailsKeys);
                if (current != null && !merge(current, contact)) {
                    continue;
                }

                emails.put(emailsKeys, contact);
                contact.calculateRanks();
            }
        }

        List<AceVenturaContact> result = new ArrayList<>(emails.values());
        result.sort(comparator);

        callback.completed(result);
    }
}
