package ru.yandex.ace.ventura.proxy;

import java.util.Collection;
import java.util.List;

import org.apache.http.HttpException;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.ace.ventura.proxy.common.AceVenturaContact;
import ru.yandex.ace.ventura.proxy.suggest.comparator.ContactsEqualTreatmentComparator;
import ru.yandex.http.util.MultiFutureCallback;
import ru.yandex.search.rules.pure.SearchRule;

public class DeduplicateByEmailRule<T extends AceVenturaProxyContext>
    implements SearchRule<T, Collection<AceVenturaContact>>
{
    private final List<SearchRule<T, List<AceVenturaContact>>> rules;

    public DeduplicateByEmailRule(
        final List<SearchRule<T, List<AceVenturaContact>>> rules)
    {
        this.rules = rules;
    }

    @Override
    public void execute(
        final T input,
        final FutureCallback<? super Collection<AceVenturaContact>> callback)
        throws HttpException
    {
        MultiFutureCallback<Collection<AceVenturaContact>> mfcb =
            new MultiFutureCallback<>(
                new DeduplicateByEmailCallback<>(input, ContactsEqualTreatmentComparator.INSTANCE, callback));

        for (SearchRule<T, List<AceVenturaContact>> rule: rules) {
            rule.execute(input, mfcb.newCallback());
        }

        mfcb.done();
    }
}
