package ru.yandex.ace.ventura.proxy.common;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;

public class AceVenturaResultTag implements JsonValue {
    private final String name;
    private final long id;
    private final Map<Long, AceVenturaContact> contacts;

    public AceVenturaResultTag(
        final long id,
        final String name)
    {
        this.name = name;
        this.id = id;
        this.contacts = new LinkedHashMap<>();
    }

    public AceVenturaResultTag(
        final long id,
        final String name,
        final int capacity)
    {
        this.name = name;
        this.id = id;
        this.contacts = new LinkedHashMap<>(capacity);
    }

    public void add(final AceVenturaContact contact) {
        this.contacts.put(contact.contactId(), contact);
    }

    public AceVenturaContact get(final Long id) {
        return contacts.get(id);
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        writer.startObject();
        writer.key("tag_id");
        writer.value(id);
        writer.key("name");
        writer.value(name);
        writer.key("contacts");
        writer.value(contacts.values());
        writer.endObject();
    }

    public String name() {
        return name;
    }

    public long id() {
        return id;
    }
}
