package ru.yandex.ace.ventura.proxy.config;

import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.config.HttpHostConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.search.proxy.universal.AbstractUniversalSearchProxyConfigBuilder;

public abstract class AbstractAceVenturaProxyConfigBuilder
    <T extends AbstractAceVenturaProxyConfigBuilder<T>>
     extends AbstractUniversalSearchProxyConfigBuilder<T>
     implements AceVenturaProxyConfig
{
    private HttpHostConfigBuilder mailSearch;
    private SuggestReportConfigBuilder suggestReport;
    private SuggestConfigBuilder suggest;
    private SearchConfigBuilder search;

    protected AbstractAceVenturaProxyConfigBuilder(final AceVenturaProxyConfig config) {
        super(config);
        mailSearch(config.mailSearch());
        suggest(config.suggest());
        search(config.search());
        suggestReport(config.suggestReport());
    }

    protected AbstractAceVenturaProxyConfigBuilder(
        final IniConfig config,
        final AceVenturaProxyConfig defaults)
        throws ConfigException
    {
        super(config, defaults);

        IniConfig mailSearchSection = config.section("mail-search");

        this.mailSearch =
            new HttpHostConfigBuilder(
                mailSearchSection,
                defaults.mailSearch());

        IniConfig suggestSection = config.section("suggest");
        if (suggestSection != null) {
            suggest = new SuggestConfigBuilder(suggestSection, defaults.suggest());
        } else {
            suggest = new SuggestConfigBuilder(defaults.suggest());
        }

        IniConfig searchRouteSection = config.section("search-route");
        if (searchRouteSection != null) {
            search = new SearchConfigBuilder(searchRouteSection, defaults.search());
        } else {
            search = new SearchConfigBuilder(defaults.search());
        }

        suggestReport =
                new SuggestReportConfigBuilder(
                        config.section("suggest-report"),
                        defaults.suggestReport());
    }

    @Override()
    public HttpHostConfigBuilder mailSearch() {
        return mailSearch;
    }

    public T mailSearch(final HttpHostConfig value) {
        this.mailSearch = new HttpHostConfigBuilder(
            value);
        return self();
    }

    @Override
    public SuggestConfigBuilder suggest() {
        return suggest;
    }

    public T suggest(final SuggestConfig suggest) {
        this.suggest = new SuggestConfigBuilder(suggest);
        return self();
    }

    @Override
    public SearchConfigBuilder search() {
        return search;
    }

    public T search(final SearchConfig config) {
        this.search = new SearchConfigBuilder(config);
        return self();
    }

    @Override
    public SuggestReportConfigBuilder suggestReport() {
        return suggestReport;
    }

    public T suggestReport(final SuggestReportConfig suggestReport) {
        this.suggestReport = new SuggestReportConfigBuilder(suggestReport);
        return self();
    }
}
