package ru.yandex.ace.ventura.proxy.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractSearchConfigBuilder
    <T extends AbstractSearchConfigBuilder<T>>
     implements SearchConfig
{
    private long failoverDelay;
    private boolean localityShuffle;

    protected AbstractSearchConfigBuilder(final SearchConfig config) {
        failoverDelay(config.failoverDelay());
        localityShuffle(config.localityShuffle());
    }

    protected AbstractSearchConfigBuilder(
        final IniConfig config,
        final SearchConfig defaults)
        throws ConfigException
    {
        this.failoverDelay =
            config.getLongDuration("failover-delay", defaults.failoverDelay());
        this.localityShuffle =
            config.getBoolean("locality-shuffle", defaults.localityShuffle());
    }

    @Override()
    public long failoverDelay() {
        return failoverDelay;
    }

    public T failoverDelay(final long value) {
        this.failoverDelay = value;
        return self();
    }

    @Override()
    public boolean localityShuffle() {
        return localityShuffle;
    }

    public T localityShuffle(final boolean value) {
        this.localityShuffle = value;
        return self();
    }

    protected abstract T self();
}
