package ru.yandex.ace.ventura.proxy.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractSuggestConfigBuilder
    <T extends AbstractSuggestConfigBuilder<T>>
     implements SuggestConfig
{
    private long failoverDelay;
    private boolean localityShuffle;
    private long zeroFailoverDelay;
    private boolean zeroLocalityShuffle;
    private long translitFailOverDelay;
    private boolean translitLocalityShuffle;

    protected AbstractSuggestConfigBuilder(final SuggestConfig config) {
        failoverDelay(config.failoverDelay());
        localityShuffle(config.localityShuffle());
        zeroFailoverDelay(config.zeroFailoverDelay());
        zeroLocalityShuffle(config.zeroLocalityShuffle());
        translitFailOverDelay(config.translitFailOverDelay());
        translitLocalityShuffle(config.translitLocalityShuffle());
    }

    protected AbstractSuggestConfigBuilder(
        final IniConfig config,
        final SuggestConfig defaults)
        throws ConfigException
    {
        this.failoverDelay =
            config.getLongDuration("failover-delay", defaults.failoverDelay());
        this.localityShuffle =
            config.getBoolean("locality-shuffle", defaults.localityShuffle());
        this.zeroFailoverDelay =
            config.getLongDuration("zero-failover-delay", defaults.zeroFailoverDelay());
        this.zeroLocalityShuffle =
            config.getBoolean(
                "zero-locality-shuffle",
                defaults.zeroLocalityShuffle());
        this.translitFailOverDelay =
            config.getLongDuration(
                "translit-fail-over-delay",
                defaults.translitFailOverDelay());
        this.translitLocalityShuffle =
            config.getBoolean(
                "translit-locality-shuffle",
                defaults.translitLocalityShuffle());
    }

    @Override()
    public long failoverDelay() {
        return failoverDelay;
    }

    public T failoverDelay(final long value) {
        this.failoverDelay = value;
        return self();
    }

    @Override()
    public boolean localityShuffle() {
        return localityShuffle;
    }

    public T localityShuffle(final boolean value) {
        this.localityShuffle = value;
        return self();
    }

    @Override()
    public long zeroFailoverDelay() {
        return zeroFailoverDelay;
    }

    public T zeroFailoverDelay(final long value) {
        this.zeroFailoverDelay = value;
        return self();
    }

    @Override()
    public boolean zeroLocalityShuffle() {
        return zeroLocalityShuffle;
    }

    public T zeroLocalityShuffle(final boolean value) {
        this.zeroLocalityShuffle = value;
        return self();
    }

    @Override()
    public long translitFailOverDelay() {
        return translitFailOverDelay;
    }

    public T translitFailOverDelay(final long value) {
        this.translitFailOverDelay = value;
        return self();
    }

    @Override()
    public boolean translitLocalityShuffle() {
        return translitLocalityShuffle;
    }

    public T translitLocalityShuffle(final boolean value) {
        this.translitLocalityShuffle = value;
        return self();
    }

    protected abstract T self();
}
