package ru.yandex.ace.ventura.proxy.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class AceVenturaProxyConfigBuilder
     extends AbstractAceVenturaProxyConfigBuilder<AceVenturaProxyConfigBuilder>
{
    public AceVenturaProxyConfigBuilder() {
        this(AceVenturaProxyConfigDefaults.INSTANCE);
    }

    public AceVenturaProxyConfigBuilder(final AceVenturaProxyConfig config) {
        super(config);
    }

    public AceVenturaProxyConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, AceVenturaProxyConfigDefaults.INSTANCE);
    }

    public AceVenturaProxyConfigBuilder(
        final IniConfig config,
        final AceVenturaProxyConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    public ImmutableAceVenturaProxyConfig build() throws ConfigException {
        return new ImmutableAceVenturaProxyConfig(
            this);
    }

    @Override
    public AceVenturaProxyConfigBuilder self() {
        return this;
    }
}
