package ru.yandex.ace.ventura.proxy.config;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.search.proxy.universal.ImmutableUniversalSearchProxyConfig;

public class ImmutableAceVenturaProxyConfig
     extends ImmutableUniversalSearchProxyConfig
     implements AceVenturaProxyConfig
{
    private final ImmutableHttpHostConfig mailSearch;
    private final ImmutableSuggestReportConfig suggestReport;
    private final ImmutableSuggestConfig suggest;
    private final ImmutableSearchConfig search;

    public ImmutableAceVenturaProxyConfig(
        final AceVenturaProxyConfig config)
        throws ConfigException
    {
        super(config);
        this.mailSearch =
            new ImmutableHttpHostConfig(
                config.mailSearch());
        this.suggest = new ImmutableSuggestConfig(config.suggest());
        this.search = new ImmutableSearchConfig(config.search());
        this.suggestReport = new ImmutableSuggestReportConfig(config.suggestReport());
    }

    @Override
    public ImmutableHttpHostConfig mailSearch() {
        return mailSearch;
    }

    @Override
    public ImmutableSuggestConfig suggest() {
        return suggest;
    }

    @Override
    public ImmutableSearchConfig search() {
        return search;
    }

    @Override
    public ImmutableSuggestReportConfig suggestReport() {
        return suggestReport;
    }
}
