package ru.yandex.ace.ventura.proxy.config;

import ru.yandex.parser.config.ConfigException;

public class ImmutableSearchConfig
     implements SearchConfig
{
    private final long failoverDelay;
    private final boolean localityShuffle;

    public ImmutableSearchConfig(
        final SearchConfig config)
        throws ConfigException
    {
        this.failoverDelay = config.failoverDelay();
        this.localityShuffle = config.localityShuffle();
    }

    @Override
    public long failoverDelay() {
        return failoverDelay;
    }

    @Override
    public boolean localityShuffle() {
        return localityShuffle;
    }
}
