package ru.yandex.ace.ventura.proxy.config;

import ru.yandex.parser.config.ConfigException;

public class ImmutableSuggestConfig
     implements SuggestConfig
{
    private final long failoverDelay;
    private final boolean localityShuffle;
    private final long zeroFailoverDelay;
    private final boolean zeroLocalityShuffle;
    private final long translitFailOverDelay;
    private final boolean translitLocalityShuffle;

    public ImmutableSuggestConfig(
        final SuggestConfig config)
        throws ConfigException
    {
        this.failoverDelay = config.failoverDelay();
        this.localityShuffle = config.localityShuffle();
        this.zeroFailoverDelay = config.zeroFailoverDelay();
        this.zeroLocalityShuffle = config.zeroLocalityShuffle();
        this.translitFailOverDelay = config.translitFailOverDelay();
        this.translitLocalityShuffle = config.translitLocalityShuffle();
    }

    @Override
    public long failoverDelay() {
        return failoverDelay;
    }

    @Override
    public boolean localityShuffle() {
        return localityShuffle;
    }

    @Override
    public long zeroFailoverDelay() {
        return zeroFailoverDelay;
    }

    @Override
    public boolean zeroLocalityShuffle() {
        return zeroLocalityShuffle;
    }

    @Override
    public long translitFailOverDelay() {
        return translitFailOverDelay;
    }

    @Override
    public boolean translitLocalityShuffle() {
        return translitLocalityShuffle;
    }
}
