package ru.yandex.ace.ventura.proxy.config;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableSuggestReportConfig extends ImmutableHttpHostConfig implements SuggestReportConfig {
    private final int queueSize;

    public ImmutableSuggestReportConfig(
            final SuggestReportConfig config)
            throws ConfigException
    {
        super(config);

        if (config.queueSize() < 0) {
            throw new ConfigException("QueueSize should be 0 for disabled or positive");
        }

        this.queueSize = config.queueSize();
    }

    @Override
    public int queueSize() {
        return queueSize;
    }
}
