package ru.yandex.ace.ventura.proxy.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class SearchConfigBuilder
     extends AbstractSearchConfigBuilder<SearchConfigBuilder>
{
    public SearchConfigBuilder() {
        this(SearchConfigDefaults.INSTANCE);
    }

    public SearchConfigBuilder(final SearchConfig config) {
        super(config);
    }

    public SearchConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, SearchConfigDefaults.INSTANCE);
    }

    public SearchConfigBuilder(
        final IniConfig config,
        final SearchConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    public ImmutableSearchConfig build() throws ConfigException {
        return new ImmutableSearchConfig(
            this);
    }

    @Override
    protected SearchConfigBuilder self() {
        return this;
    }
}
