package ru.yandex.ace.ventura.proxy.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class SuggestConfigBuilder
     extends AbstractSuggestConfigBuilder<SuggestConfigBuilder>
{
    public SuggestConfigBuilder() {
        this(SuggestConfigDefaults.INSTANCE);
    }

    public SuggestConfigBuilder(final SuggestConfig config) {
        super(config);
    }

    public SuggestConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, SuggestConfigDefaults.INSTANCE);
    }

    public SuggestConfigBuilder(
        final IniConfig config,
        final SuggestConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    public ImmutableSuggestConfig build() throws ConfigException {
        return new ImmutableSuggestConfig(
            this);
    }

    @Override
    protected SuggestConfigBuilder self() {
        return this;
    }
}
