package ru.yandex.ace.ventura.proxy.config;

import ru.yandex.http.config.AbstractHttpHostConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.string.NonNegativeIntegerValidator;

public class SuggestReportConfigBuilder
        extends AbstractHttpHostConfigBuilder<SuggestReportConfigBuilder>
        implements SuggestReportConfig
{
    private int queueSize;

    public SuggestReportConfigBuilder() {
        this(SuggestReportConfigDefaults.INSTANCE);
    }

    public SuggestReportConfigBuilder(final SuggestReportConfig config) {
        super(config);

        this.queueSize = config.queueSize();
    }

    public SuggestReportConfigBuilder(
            final IniConfig config)
            throws ConfigException
    {
        this(config, SuggestReportConfigDefaults.INSTANCE);
    }

    public SuggestReportConfigBuilder(
            final IniConfig config,
            final SuggestReportConfig defaults)
            throws ConfigException
    {
        super(config, defaults);

        queueSize =
                config.get("queue-size", defaults.queueSize(), NonNegativeIntegerValidator.INSTANCE);
    }

    public ImmutableSuggestReportConfig build() throws ConfigException {
        return new ImmutableSuggestReportConfig(this);
    }

    @Override
    public SuggestReportConfigBuilder self() {
        return this;
    }

    @Override
    public int queueSize() {
        return queueSize;
    }
}
