package ru.yandex.ace.ventura.proxy.feedback;

import ru.yandex.ace.ventura.proxy.AbstractAceVenturaProxyContext;
import ru.yandex.ace.ventura.proxy.AceVenturaProxy;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;

public class FeedbackAceVenturaContext extends AbstractAceVenturaProxyContext {
    private final String request;
    private final String title;
    private final Long tagId;
    private final Long contactId;
    private final long updateTs;

    public FeedbackAceVenturaContext(
        final AceVenturaProxy proxy,
        final ProxySession session)
        throws BadRequestException
    {
        super(proxy, session);

        String request = session.params().getString("q", null);
        if (request == null) {
            request = session.params().getString("request");
        }

        this.request = request;

        Long tagId = null;
        Long contactId = session.params().getLong("contact_id", null);
        if (contactId == null) {
            tagId = session.params().getLong("tag_id", null);
        }

        this.tagId = tagId;
        this.contactId = contactId;

        this.title = session.params().getString("title", null);
        this.updateTs =
            session.params().getLong("ts", System.currentTimeMillis());
    }

    @Override
    public Long failOverDelay() {
        return 500L;
    }

    public String request() {
        return request;
    }

    public String title() {
        return title;
    }

    public Long tagId() {
        return tagId;
    }

    public Long contactId() {
        return contactId;
    }

    public long updateTs() {
        return updateTs;
    }

    @Override
    public int length() {
        return 0;
    }
}
