package ru.yandex.ace.ventura.proxy.fetch;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

import ru.yandex.ace.ventura.proxy.AbstractAceVenturaProxyContext;
import ru.yandex.ace.ventura.proxy.AceVenturaProxy;
import ru.yandex.ace.ventura.proxy.AceVenturaProxyParams;
import ru.yandex.ace.ventura.proxy.common.SharedScope;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.parser.string.CollectionParser;
import ru.yandex.parser.string.EnumParser;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.uri.CgiParams;
import ru.yandex.search.rules.pure.providers.RequestProvider;

public class BasicCommonSearchContext
    extends AbstractAceVenturaProxyContext
    implements RequestProvider, SearchContextProvider
{
    private static final CollectionParser<SearchTransform,
        Set<SearchTransform>, ? extends Exception>
        TRANSFORM_PARSER =
        new CollectionParser<>(
            new EnumParser<>(SearchTransform.class),
            LinkedHashSet::new);
    private static final CollectionParser<String, Set<String>, Exception>
        STRING_SET_PARSER =
        new CollectionParser<>(
            NonEmptyValidator.TRIMMED, LinkedHashSet::new);

    private final String request;
    private final Set<SearchTransform> transform;
    private final Set<String> searchBy;
    private final SharedScope shared;
    private final Long tagId;
    private final int page;
    private final int pageSize;
    private final Set<String> sortFields;

    public BasicCommonSearchContext(
        final AceVenturaProxy proxy,
        final ProxySession session)
        throws BadRequestException
    {
        super(proxy, session);

        CgiParams params = session.params();
        this.request = params.getString(AceVenturaProxyParams.QUERY);

        this.transform =
            params.get("transform", Collections.emptySet(), TRANSFORM_PARSER);
        this.searchBy =
            params.get("search_by", Collections.emptySet(), STRING_SET_PARSER);
        this.shared = params.getEnum(SharedScope.class, "shared");
        this.tagId = params.getLong("tag_id", null);
        this.page = params.getInt("page");
        this.pageSize = params.getInt("page_size");
        this.sortFields =
            params.get("sort_by", Collections.emptySet(), STRING_SET_PARSER);
    }

    @Override
    public BasicCommonSearchContext searchContext() {
        return this;
    }

    @Override
    public String request() {
        return request;
    }

    public Set<SearchTransform> transform() {
        return transform;
    }

    public Set<String> searchBy() {
        return searchBy;
    }

    public SharedScope shared() {
        return shared;
    }

    public Long tagId() {
        return tagId;
    }

    public int page() {
        return page;
    }

    public int pageSize() {
        return pageSize;
    }

    public Set<String> sortFields() {
        return sortFields;
    }

    @Override
    public int length() {
        return pageSize * page;
    }

    @Override
    public Long failOverDelay() {
        return 300L;
    }
}
