package ru.yandex.ace.ventura.proxy.fetch;

import java.util.Collection;
import java.util.Collections;

import org.apache.http.HttpException;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.ace.ventura.AceVenturaIndexFields;
import ru.yandex.ace.ventura.proxy.AceVenturaProxy;
import ru.yandex.ace.ventura.proxy.common.AceVenturaContact;
import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.json.async.consumer.JsonAsyncTypesafeDomConsumerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.search.request.util.SearchRequestText;
import ru.yandex.search.rules.pure.SearchRule;
import ru.yandex.search.rules.pure.providers.RequestProvider;

public class CommonSearchRule<T extends RequestProvider & SearchContextProvider>
    implements SearchRule<T, CommonSearchResult>
{
    private static final Collection<String> SEARCH_FIELDS =
        Collections.singleton(AceVenturaIndexFields.NAMES);

    private final AceVenturaProxy proxy;

    public CommonSearchRule(final AceVenturaProxy proxy) {
        this.proxy = proxy;
    }

    public AceVenturaProxy proxy() {
        return proxy;
    }

    @Override
    public void execute(
        final T input,
        final FutureCallback<? super CommonSearchResult> callback)
        throws HttpException
    {
        BasicCommonSearchContext context = input.searchContext();

        SearchRequestText request = SearchRequestText.parseSuggest(
            input.request(),
            context.locale());

        StringBuilder textSb = new StringBuilder();

        textSb.append('(');

        if (request.hasWords()) {
            request.fieldsQuery(textSb, SEARCH_FIELDS);
        }

        request.negationsQuery(textSb, SEARCH_FIELDS);
        textSb.append(')');

        QueryConstructor query =
            new QueryConstructor(
                "/search-ace-common?IO_PRIO=0&json-type=dollar");

        query.append("service", context.user().service());
        query.append("text", new String(textSb));
        query.append("length", context.length());
        query.append("prefix", context.user().prefix().toStringFast());

        context.proxy().parallelRequest(
            context.session(),
            context,
            new BasicAsyncRequestProducerGenerator(query.toString()),
            JsonAsyncTypesafeDomConsumerFactory.OK,
            context.contextGenerator(),
            new SearchCallback(context, callback));
    }

    private static class SearchCallback
        extends AbstractFilterFutureCallback<JsonObject, CommonSearchResult>
    {
        private final BasicCommonSearchContext context;

        public SearchCallback(
            final BasicCommonSearchContext context,
            final FutureCallback<? super CommonSearchResult> callback)
        {
            super(callback);

            this.context = context;
        }

        @Override
        public void completed(final JsonObject response) {
            try {
                JsonMap map = response.asMap();
                //long total = map.getLong("hitsCount");
                JsonList hits = map.getList("hitsArray");

                CommonSearchResult result =
                    new CommonSearchResult(hits.size());
                for (JsonObject item: hits) {
                    result.add(
                        AceVenturaContact.fromLuceneResponse(
                            context.session().logger(),
                            context.prefix(),
                            item.asMap()));
                }

                callback.completed(result);
            } catch (JsonException je) {
                failed(je);
            }
        }
    }
}
