package ru.yandex.ace.ventura.proxy.fetch;

import java.util.List;

import ru.yandex.search.rules.pure.providers.RequestsProvider;

public class SearchRequestsContextProvider
    implements RequestsProvider, SearchContextProvider
{
    private final BasicCommonSearchContext context;
    private final List<String> requests;

    public SearchRequestsContextProvider(
        final BasicCommonSearchContext context,
        final List<String> requests)
    {
        this.context = context;
        this.requests = requests;
    }

    @Override
    public BasicCommonSearchContext searchContext() {
        return context;
    }

    @Override
    public List<String> requests() {
        return requests;
    }
}
