package ru.yandex.ace.ventura.proxy.fetch.contact;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;

import ru.yandex.ace.ventura.AceVenturaConstants;
import ru.yandex.ace.ventura.AceVenturaIndexFields;
import ru.yandex.ace.ventura.AceVenturaPrefix;
import ru.yandex.ace.ventura.UserType;
import ru.yandex.ace.ventura.proxy.AceVenturaProxy;
import ru.yandex.ace.ventura.proxy.common.AceVenturaContact;
import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.NotFoundException;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.async.consumer.JsonAsyncTypesafeDomConsumerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.parser.searchmap.User;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.search.proxy.universal.PlainUniversalSearchProxyRequestContext;

public class SearchByContactIdHandler implements ProxyRequestHandler {
    private final AceVenturaProxy proxy;

    public SearchByContactIdHandler(final AceVenturaProxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public void handle(final ProxySession session)
        throws HttpException, IOException
    {
        Long userId =
            session.params().getLong("contact_owner_user_id");
        UserType userType =
            session.params().getEnum(UserType.class, "contact_owner_user_type");
        Long contactId = session.params().getLong("contact_id");
        AceVenturaPrefix prefix = new AceVenturaPrefix(userId, userType);
        String url = AceVenturaIndexFields.url(prefix, contactId);

        AsyncClient client = proxy.searchClient().adjust(session.context());
        PlainUniversalSearchProxyRequestContext context =
            new PlainUniversalSearchProxyRequestContext(
                new User(AceVenturaConstants.ACEVENTURA_QUEUE, prefix),
                null,
                true,
                client,
                session.logger());
        QueryConstructor qc = new QueryConstructor("/search-ace-by-cid?");
        qc.append("prefix", prefix.toStringFast());
        qc.append("service", AceVenturaConstants.ACEVENTURA_QUEUE);
        qc.append("get", "*");
        qc.append("length", "1");
        qc.append("text", "id:" + url);

        proxy.parallelRequest(
            session,
            context,
            new BasicAsyncRequestProducerGenerator(qc.toString()),
            JsonAsyncTypesafeDomConsumerFactory.OK,
            session.listener().adjustContextGenerator(client
                .httpClientContextGenerator()),
            new Callback(session, prefix));
    }

    private static class Callback
        extends AbstractProxySessionCallback<JsonObject>
    {
        private final JsonType jsonType;
        private final AceVenturaPrefix prefix;

        public Callback(
            final ProxySession session,
            final AceVenturaPrefix prefix)
            throws BadRequestException
        {
            super(session);

            jsonType = JsonTypeExtractor.NORMAL.extract(session.params());
            this.prefix = prefix;
        }

        @Override
        public void completed(final JsonObject response) {
            StringBuilderWriter sbw = new StringBuilderWriter();

            try (JsonWriter writer = jsonType.create(sbw)) {
                JsonMap map = response.asMap();
                //long total = map.getLong("hitsCount");
                JsonList hits = map.getList("hitsArray");

                if (hits.size() == 0) {
                    failed(new NotFoundException("Contact not found"));
                } else {
                    writer.value(AceVenturaContact.fromLuceneResponse(
                        session.logger(),
                        prefix,
                        hits.get(0).asMap()));
                }
            } catch (IOException | JsonException e) {
                failed(e);
                return;
            }

            session.response(
                HttpStatus.SC_OK,
                new NStringEntity(
                    sbw.toString(),
                    ContentType.APPLICATION_JSON
                        .withCharset(session.acceptedCharset())));
        }
    }
}
