package ru.yandex.ace.ventura.proxy.fetch.email;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

import ru.yandex.ace.ventura.proxy.AbstractAceVenturaProxyContext;
import ru.yandex.ace.ventura.proxy.AceVenturaProxy;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.parser.string.CollectionParser;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.string.PositiveIntegerValidator;
import ru.yandex.search.proxy.universal.UniversalSearchProxyRequestContext;

public class BasicSearchByEmailContext
    extends AbstractAceVenturaProxyContext
    implements UniversalSearchProxyRequestContext, SearchByEmailContext
{
    private static final int DEFAULT_LIMIT = 10;
    private static final Long DEFAULT_FAILOVER = 150L;

    private final Set<String> emails;
    private final int limit;
    private final ContactsMergeType mergeType;

    private static final CollectionParser<String, Set<String>, Exception>
        STRING_SET_PARSER =
        new CollectionParser<>(
            NonEmptyValidator.TRIMMED, LinkedHashSet::new);

    public BasicSearchByEmailContext(
        final AceVenturaProxy proxy,
        final ProxySession session) throws BadRequestException
    {
        super(proxy, session);

        emails = session.params().get("email", STRING_SET_PARSER);

        limit = session.params().get(
            "limit",
            DEFAULT_LIMIT,
            PositiveIntegerValidator.INSTANCE);

        mergeType = session.params().getEnum(ContactsMergeType.class, "merge", ContactsMergeType.PERSONAL);
    }

    public BasicSearchByEmailContext(
        final SearchByEmailContext context,
        final int limit,
        final Set<String> emails)
        throws BadRequestException
    {
        super(context.proxy(), context.session());

        this.emails = emails;
        this.limit = limit;
        this.mergeType = context.mergeType();
    }

    @Override
    public ContactsMergeType mergeType() {
        return mergeType;
    }

    @Override
    public Set<String> emails() {
        return emails;
    }

    @Override
    public Long failOverDelay() {
        return DEFAULT_FAILOVER;
    }

    @Override
    public int length() {
        return limit;
    }

    @Override
    public SearchByEmailContext searchContext() {
        return this;
    }

    @Override
    public Collection<Long> listIdFilter() {
        return Collections.emptySet();
    }
}
