package ru.yandex.ace.ventura.proxy.fetch.email;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;

import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;

import ru.yandex.ace.ventura.proxy.common.AceVenturaContact;
import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonWriter;

public class SearchByEmailPrinter
    extends AbstractProxySessionCallback<Collection<Map.Entry<String, AceVenturaContact>>>
{
    private final JsonType jsonType;

    public SearchByEmailPrinter(
        final SearchByEmailContext context)
        throws BadRequestException
    {
        super(context.session());
        jsonType = JsonTypeExtractor.NORMAL.extract(session.params());
    }

    @Override
    public void completed(final Collection<Map.Entry<String, AceVenturaContact>> result) {
        StringBuilderWriter sbw = new StringBuilderWriter();

        try (JsonWriter writer = jsonType.create(sbw)) {
            writer.startObject();
            for (Map.Entry<String, AceVenturaContact> entry: result) {
                writer.key(entry.getKey());
                writer.value(entry.getValue());
            }
            writer.endObject();

        } catch (IOException ioe) {
            failed(ioe);
            return;
        }

        session.response(
            HttpStatus.SC_OK,
            new NStringEntity(
                sbw.toString(),
                ContentType.APPLICATION_JSON
                    .withCharset(session.acceptedCharset())));
    }
}
