package ru.yandex.ace.ventura.proxy.fetch.email;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.http.HttpException;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.ace.ventura.AceVenturaPrefix;
import ru.yandex.ace.ventura.proxy.AceVenturaProxy;
import ru.yandex.ace.ventura.proxy.AceVenturaProxyContext;
import ru.yandex.ace.ventura.proxy.common.AbstractSharedRule;
import ru.yandex.ace.ventura.proxy.common.AceVenturaContact;
import ru.yandex.ace.ventura.proxy.common.AceVenturaProxyContextProvider;
import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.http.util.MultiFutureCallback;
import ru.yandex.search.rules.pure.SearchRule;

public class SharedSearchByEmailRule<
    M extends SearchByEmailContext,
    T extends AceVenturaProxyContextProvider<M>>
    extends AbstractSharedRule<M, T, Map<String, AceVenturaContact>>
    implements SearchRule<T, Map<String, AceVenturaContact>>
{
    private final SearchRule<? super SearchByEmailContext, Map<String, AceVenturaContact>> next;

    public SharedSearchByEmailRule(
        final AceVenturaProxy proxy,
        final SearchRule<? super SearchByEmailContext, Map<String, AceVenturaContact>> next)
    {
        super(proxy, Collections.emptyMap());

        this.next = next;
    }

    @Override
    protected void execute(
        final M context,
        final Map<AceVenturaPrefix, List<Long>> listMap,
        final FutureCallback<? super Map<String, AceVenturaContact>> callback)
        throws HttpException
    {
        MultiFutureCallback<Map<String, AceVenturaContact>> mfcb =
            new MultiFutureCallback<>(new ConcatCallback(
                callback,
                context));
        for (Map.Entry<AceVenturaPrefix, List<Long>> entry : listMap.entrySet()) {
            context.logger().fine(
                "Executing shared search for "
                    + entry.getKey() + " "
                    + entry.getValue());

            next.execute(
                new ShareSearchByEmailContext(context, entry.getValue(), entry.getKey()),
                mfcb.newCallback());
        }

        mfcb.done();
    }

    private static final class ConcatCallback
        extends AbstractFilterFutureCallback<
        List<Map<String, AceVenturaContact>>,
        Map<String, AceVenturaContact>>
    {
        private final AceVenturaProxyContext context;

        public ConcatCallback(
            final FutureCallback<? super Map<String, AceVenturaContact>> callback,
            final AceVenturaProxyContext context)
        {
            super(callback);
            this.context = context;
        }

        @Override
        public void completed(final List<Map<String, AceVenturaContact>> response) {
            if (context.debug()) {
                context.logger().fine(
                    "Shared search completed with " + response);
            }

            Map<String, AceVenturaContact> result =
                new LinkedHashMap<>(response.size() * context.length());

            for (Map<String, AceVenturaContact> map: response) {
                for (Map.Entry<String, AceVenturaContact> entry: map.entrySet()) {
                    entry.getValue().shared(true);
                    result.putIfAbsent(entry.getKey(), entry.getValue());
                }
            }

            callback.completed(result);
        }
    }
}
