package ru.yandex.ace.ventura.proxy.list;

import java.io.IOException;
import java.util.List;

import org.apache.http.HttpException;

import ru.yandex.ace.ventura.AceVenturaFields;
import ru.yandex.ace.ventura.proxy.AceVenturaProxy;
import ru.yandex.ace.ventura.proxy.common.AceVenturaContact;
import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.search.rules.pure.SearchRule;

public class ListContactsHandler implements ProxyRequestHandler {
    protected static final String GET_FIELDS =
        AceVenturaFields.TAGS.stored() + ',' +
            AceVenturaFields.REVISION.stored() + ',' +
            AceVenturaFields.VCARD.stored() + ',' +
            AceVenturaFields.LIST_ID.stored() + ',' +
            AceVenturaFields.CID.stored() + ',' +
            AceVenturaFields.EMAIL_CID.stored() + ',' +
            AceVenturaFields.EMAIL.stored() + ',' +
            AceVenturaFields.EMAIL_ID.stored() + ',' +
            AceVenturaFields.LAST_USAGE.stored();

    protected static final String LEFT_JOIN_DP =
        "left_join(" + AceVenturaFields.EMAIL_CID.stored()
            + ',' + AceVenturaFields.CID.prefixed()
            // get/out fields
            + ",," + AceVenturaFields.VCARD.stored()
            + ',' + AceVenturaFields.TAGS.stored()
            + ',' + AceVenturaFields.REVISION.stored()
            + ',' + AceVenturaFields.LIST_ID.stored() + ')';

    private final AceVenturaProxy proxy;
    protected static final String OR = " OR ";
    protected static final String AND = " AND ";

    private final SearchRule<ListContactsContext, List<AceVenturaContact>> rule;
    private final SearchRule<ListContactsContext, List<List<AceVenturaContact>>> shared;
    private final SearchRule<ListContactsContext, List<AceVenturaContact>> personal;

    public ListContactsHandler(final AceVenturaProxy proxy) {
        this.proxy = proxy;

        personal = new ListContactsFetchRule(proxy);

        shared = new ListContactsSharedRule(proxy, personal);
        rule = new ListContactsShareAndPersonalRule<>(personal, shared);
    }

    @Override
    public void handle(
        final ProxySession session)
        throws HttpException, IOException
    {
        ListContactsContext context =
            new PersonalListContactsContext(proxy, session);
        rule.execute(context, context.callback());
    }
}
