package ru.yandex.ace.ventura.proxy.list;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.apache.http.HttpException;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.ace.ventura.AceVenturaPrefix;
import ru.yandex.ace.ventura.proxy.AceVenturaProxy;
import ru.yandex.ace.ventura.proxy.common.AbstractSharedRule;
import ru.yandex.ace.ventura.proxy.common.AceVenturaContact;
import ru.yandex.http.util.MultiFutureCallback;
import ru.yandex.http.util.server.UpstreamStaterFutureCallback;
import ru.yandex.search.rules.pure.SearchRule;

public class ListContactsSharedRule
    extends AbstractSharedRule<ListContactsContext, ListContactsContext, List<List<AceVenturaContact>>>
    implements SearchRule<ListContactsContext, List<List<AceVenturaContact>>>
{
    private final SearchRule<ListContactsContext, List<AceVenturaContact>> next;

    public ListContactsSharedRule(
        final AceVenturaProxy proxy,
        final SearchRule<ListContactsContext, List<AceVenturaContact>> next)
    {
        super(proxy, Collections.emptyList());

        this.next = next;
    }

    @Override
    protected void execute(
        final ListContactsContext context,
        final Map<AceVenturaPrefix, List<Long>> listMap,
        final FutureCallback<? super List<List<AceVenturaContact>>> callback)
        throws HttpException
    {
        MultiFutureCallback<List<AceVenturaContact>> mfcb =
            new MultiFutureCallback<>(callback);
        for (Map.Entry<AceVenturaPrefix, List<Long>> entry
            : listMap.entrySet())
        {
            context.logger().fine(
                "Executing shared suggest for "
                    + entry.getKey() + " "
                    + entry.getValue());

            next.execute(
                new SharedListContactsContext(
                    context,
                    entry.getValue(),
                    entry.getKey()),
                new UpstreamStaterFutureCallback<>(
                    mfcb.newCallback(),
                    proxy.upstreamStater()));
        }

        mfcb.done();
    }
}
