package ru.yandex.ace.ventura.proxy.list;

import java.io.IOException;
import java.util.List;

import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;

import ru.yandex.ace.ventura.proxy.common.AceVenturaContact;
import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.logger.SearchProxyAccessLoggerConfigDefaults;

final class ListPrinter
    extends AbstractProxySessionCallback<List<AceVenturaContact>>
{
    private final PersonalListContactsContext context;

    public ListPrinter(final PersonalListContactsContext context) {
        super(context.session());

        this.context = context;
    }

    @Override
    public void completed(final List<AceVenturaContact> result) {
        StringBuilderWriter sbw = new StringBuilderWriter();

        context.session().connection().setSessionInfo(
            SearchProxyAccessLoggerConfigDefaults.HITS_COUNT,
            Long.toString(result.size()));
        StringBuilder sb = new StringBuilder(100);
        sb.append("Found contacts ");
        sb.append(result.size());

        context.session().logger().info(sb.toString());
        try (JsonWriter writer = context.jsonType().create(sbw)) {
            writer.startObject();
            writer.key("contacts");
            writer.startArray();
            for (int i = context.offset(); i < Math.min(result.size(), context.offset() + context.length()); i++) {
                writer.value(result.get(i));
            }
            writer.endArray();
            writer.endObject();
        } catch (IOException e) {
            failed(e);
        }

        session.response(
            HttpStatus.SC_OK,
            new NStringEntity(
                sbw.toString(),
                ContentType.APPLICATION_JSON
                    .withCharset(context.session().acceptedCharset())));
    }
}
