package ru.yandex.ace.ventura.proxy.list;

import java.util.Collections;
import java.util.List;

import ru.yandex.ace.ventura.AceVenturaPrefix;
import ru.yandex.ace.ventura.proxy.AbstractAceVenturaProxyContext;
import ru.yandex.ace.ventura.proxy.AceVenturaProxy;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.parser.string.EnumParser;

public class PersonalListContactsContext
    extends AbstractAceVenturaProxyContext
    implements ListContactsContext
{
    private static final EnumParser<ListSort> SORTING_PARSER
        = new EnumParser<>(ListSort.class);

    private static final int DEFAULT_FAILOVER = 150;

    private final int offset;
    private final int length;
    private final int totalLength;
    private final int failover;
    private final ListSort sort;
    private final ListPrinter callback;

    public PersonalListContactsContext(
        final AceVenturaProxy proxy,
        final ProxySession session)
        throws BadRequestException
    {
        super(proxy, session);

        offset = session.params().getInt("offset", 0);
        int length = session.params().getInt("length", -1);
        if (length < 0) {
            length = session.params().getInt("limit");
        }

        this.length = length;
        this.totalLength = offset + this.length;

        failover = session.params().getInt("failover", DEFAULT_FAILOVER);
        sort = session.params().get("sort", ListSort.LAST_USAGE, SORTING_PARSER);
        callback = new ListPrinter(this);
    }


    @Override
    public PersonalListContactsContext searchContext() {
        return this;
    }

    @Override
    public int totalLength() {
        return totalLength;
    }

    @Override
    public Long failOverDelay() {
        return (long) failover;
    }

    @Override
    public int length() {
        return length;
    }

    @Override
    public int offset() {
        return offset;
    }

    @Override
    public ListPrinter callback() {
        return callback;
    }

    @Override
    public ListSort sort() {
        return sort;
    }

    public SharedListContactsContext sharedContext(
        final AceVenturaPrefix prefix,
        final List<Long> listIds)
    {
        return new SharedListContactsContext(this, listIds, prefix);
    }

    @Override
    public List<Long> listIds() {
        return Collections.emptyList();
    }
}
