package ru.yandex.ace.ventura.proxy.search;

import java.util.Collection;
import java.util.Locale;
import java.util.Set;

import ru.yandex.ace.ventura.proxy.AceVenturaProxyContext;
import ru.yandex.ace.ventura.proxy.fetch.SearchTransform;
import ru.yandex.search.rules.pure.providers.RequestProvider;

public interface AceVenturaSearchContext
    extends AceVenturaProxyContext,
    RequestProvider,
    AceVenturaSearchContextProvider
{
    Set<SearchTransform> transforms();

    Set<String> fields();

    Set<String> searchBy();

    Set<String> sortBy();

    Long tagId();

    Collection<Long> listIds();

    int offset();

    default boolean english() {
        return corp() && Locale.ENGLISH.equals(locale());
    }
}
