package ru.yandex.ace.ventura.proxy.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import org.apache.http.HttpException;

import ru.yandex.ace.ventura.proxy.AceVenturaProxy;
import ru.yandex.ace.ventura.proxy.DeduplicateByEmailRule;
import ru.yandex.ace.ventura.proxy.common.AceVenturaContact;
import ru.yandex.ace.ventura.proxy.fetch.SearchTransform;
import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.search.rules.pure.ChainedSearchRule;
import ru.yandex.search.rules.pure.ConcatResultsRule;
import ru.yandex.search.rules.pure.SearchRule;
import ru.yandex.search.rules.pure.TranslitRule;

public class SearchHandler implements ProxyRequestHandler {
    private final AceVenturaProxy proxy;

    private final SearchRule<AceVenturaSearchContext,
        Collection<AceVenturaContact>> translitRule;
    private final SearchRule<AceVenturaSearchContext,
        Collection<AceVenturaContact>> commonRule;

    public SearchHandler(final AceVenturaProxy proxy) {
        this.proxy = proxy;

        SearchRule<AceVenturaSearchContext,
            List<AceVenturaContact>> translitRule =
            new TranslitRule<>(
                new ChainedSearchRule<>(
                    new ConcatResultsRule<>(
                        new ChainedSearchRule<>(
                            new AceVenturaSearchRule<>(proxy),
                            (input, request) ->
                                new AceVenturaSearchRequestContextProvider(
                                    input.searchContext(),
                                    request))),
                    (input, requests) ->
                        new AceVenturaSearchRequestsContextProvider(
                            input.searchContext(),
                            requests)),
                true);
        this.translitRule =
            new DeduplicateByEmailRule<>(
                Arrays.asList(translitRule,
                    new SharedSearchRule<>(
                        proxy,
                        translitRule)));

        commonRule = new DeduplicateByEmailRule<>(
            Arrays.asList(new AceVenturaSearchRule<>(proxy),
                new SharedSearchRule<>(
                    proxy,
                    new AceVenturaSearchRule<>(proxy))));
    }

    @Override
    public void handle(final ProxySession session)
        throws HttpException, IOException
    {
        BasicAceVenturaSearchContext searchContext =
            new BasicAceVenturaSearchContext(proxy, session);

        //searchContext.prefix().uid() == 1120000000092594L ||
        if (searchContext.prefix().uid() == 1120000000038012L ||
            searchContext.prefix().uid() == 1120000000040290L)
        {
            searchContext.forceEnglish();
        }

        SearchResultPrinter printer =
            new SearchResultPrinter(session, searchContext);
        if (searchContext.transforms().contains(SearchTransform.TRANSLIT)) {
            translitRule.execute(searchContext, printer);
        } else {
            commonRule.execute(searchContext, printer);
        }
    }
}
