package ru.yandex.ace.ventura.proxy.search;

import java.io.IOException;
import java.util.Collection;

import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;

import ru.yandex.ace.ventura.proxy.common.AceVenturaContact;
import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.writer.JsonWriter;

public class SearchResultPrinter
    extends AbstractProxySessionCallback<Collection<AceVenturaContact>>
{
    private final BasicAceVenturaSearchContext context;
    public SearchResultPrinter(
        final ProxySession session,
        final BasicAceVenturaSearchContext context)
    {
        super(session);

        this.context = context;
    }

    @Override
    public void completed(
        final Collection<AceVenturaContact> result)
    {
        StringBuilderWriter sbw = new StringBuilderWriter();
        try (JsonWriter writer = context.jsonType().create(sbw)) {
            writer.startObject();
            writer.key("contacts");

            writer.startArray();
            int max = Math.min(result.size(), context.length());
            int min = context.offset();
            int i = 0;
            for (AceVenturaContact contact: result) {
                if (i < min) {
                    continue;
                }

                if (i >= max) {
                    break;
                }

                writer.value(contact);

                i++;
            }
            writer.endArray();

            writer.key("total");
            writer.value(result.size());
            writer.key("next-page");

            if (result.size() >= context.length()) {
                writer.value(true);
            } else {
                writer.value(false);
            }

            writer.endObject();
        } catch (IOException ioe) {
            failed(ioe);
            return;
        }

        session.response(
            HttpStatus.SC_OK,
            new NStringEntity(
                sbw.toString(),
                ContentType.APPLICATION_JSON
                    .withCharset(context.session().acceptedCharset())));
    }
}
