package ru.yandex.ace.ventura.proxy.search;

import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Logger;

import org.apache.http.client.protocol.HttpClientContext;

import ru.yandex.ace.ventura.AceVenturaPrefix;
import ru.yandex.ace.ventura.proxy.AceVenturaProxy;
import ru.yandex.ace.ventura.proxy.common.SharedScope;
import ru.yandex.ace.ventura.proxy.fetch.SearchTransform;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.nio.client.AbstractAsyncClient;
import ru.yandex.json.writer.JsonType;
import ru.yandex.parser.searchmap.User;

public class ShareAceVenturaSearchContext implements AceVenturaSearchContext {
    private final AceVenturaSearchContext context;
    private final Collection<Long> listIds;
    private final AceVenturaPrefix prefix;
    private final User user;

    public ShareAceVenturaSearchContext(
        final AceVenturaSearchContext context,
        final Collection<Long> listIds, final AceVenturaPrefix prefix)
    {
        this.context = context;
        this.listIds = listIds;
        this.prefix = prefix;

        this.user = new User(context.user().service(), prefix);
    }

    @Override
    public AceVenturaPrefix prefix() {
        return prefix;
    }

    @Override
    public Collection<Long> listIds() {
        return listIds;
    }

    @Override
    public User user() {
        return user;
    }

    @Override
    public SharedScope shareScope() {
        return SharedScope.EXCLUDE;
    }

    @Override
    public Set<SearchTransform> transforms() {
        return context.transforms();
    }

    @Override
    public Set<String> fields() {
        return context.fields();
    }

    @Override
    public Set<String> searchBy() {
        return context.searchBy();
    }

    @Override
    public Set<String> sortBy() {
        return context.sortBy();
    }

    @Override
    public Long tagId() {
        return context.tagId();
    }

    @Override
    public int offset() {
        return context.offset();
    }

    @Override
    public AceVenturaProxy proxy() {
        return context.proxy();
    }

    @Override
    public ProxySession session() {
        return context.session();
    }

    @Override
    public Supplier<? extends HttpClientContext> contextGenerator() {
        return context.contextGenerator();
    }

    @Override
    public JsonType jsonType() {
        return context.jsonType();
    }

    @Override
    public Long failOverDelay() {
        return context.failOverDelay();
    }

    @Override
    public int length() {
        return context.length();
    }

    @Override
    public Long minPos() {
        return context.minPos();
    }

    @Override
    public AbstractAsyncClient<?> client() {
        return context.client();
    }

    @Override
    public Logger logger() {
        return context.logger();
    }

    @Override
    public long lagTolerance() {
        return context.lagTolerance();
    }

    @Override
    public Locale locale() {
        return context.locale();
    }

    @Override
    public AceVenturaSearchContext searchContext() {
        return this;
    }

    @Override
    public String request() {
        return context.request();
    }

    @Override
    public boolean debug() {
        return context.debug();
    }

    @Override
    public boolean corp() {
        return context.corp();
    }

    @Override
    public boolean english() {
        return context.english();
    }
}
