package ru.yandex.ace.ventura.proxy.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.apache.http.HttpException;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.ace.ventura.AceVenturaPrefix;
import ru.yandex.ace.ventura.proxy.AceVenturaProxy;
import ru.yandex.ace.ventura.proxy.common.AbstractSharedRule;
import ru.yandex.ace.ventura.proxy.common.AceVenturaContact;
import ru.yandex.ace.ventura.proxy.common.SharedScope;
import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.http.util.MultiFutureCallback;
import ru.yandex.search.rules.pure.SearchRule;
import ru.yandex.search.rules.pure.providers.RequestProvider;

public class SharedSearchRule<
    T extends RequestProvider & AceVenturaSearchContextProvider>
    extends AbstractSharedRule<AceVenturaSearchContext, T, List<AceVenturaContact>>
    implements SearchRule<T, List<AceVenturaContact>>
{
    private final SearchRule<? super AceVenturaSearchContext, List<AceVenturaContact>> next;

    public SharedSearchRule(
        final AceVenturaProxy proxy,
        final SearchRule<? super AceVenturaSearchContext, List<AceVenturaContact>> next)
    {
        super(proxy, Collections.emptyList());

        this.next = next;
    }

    @Override
    protected void execute(
        final AceVenturaSearchContext context,
        final Map<AceVenturaPrefix, List<Long>> listMap,
        final FutureCallback<? super List<AceVenturaContact>> callback)
        throws HttpException
    {
        MultiFutureCallback<List<AceVenturaContact>> mfcb =
            new MultiFutureCallback<>(new ConcatCallback(
                callback,
                context));
        for (Map.Entry<AceVenturaPrefix, List<Long>> entry
            : listMap.entrySet())
        {
            context.logger().fine(
                "Executing shared search for "
                    + entry.getKey() + " "
                    + entry.getValue());

            next.execute(
                new ShareAceVenturaSearchContext(
                    context,
                    entry.getValue(),
                    entry.getKey()),
                mfcb.newCallback());
        }

        mfcb.done();
    }

    private static final class ConcatCallback
        extends AbstractFilterFutureCallback<List<List<AceVenturaContact>>, List<AceVenturaContact>>
    {
        private final AceVenturaSearchContext context;

        public ConcatCallback(
            final FutureCallback<? super List<AceVenturaContact>> callback,
            final AceVenturaSearchContext context)
        {
            super(callback);
            this.context = context;
        }

        @Override
        public void completed(final List<List<AceVenturaContact>> response) {
            if (context.debug()) {
                context.logger().fine(
                    "Shared search completed with " + response);
            }

            List<AceVenturaContact> result =
                new ArrayList<>(response.size() * context.length());
            for (List<AceVenturaContact> list: response) {
                for (AceVenturaContact contact: list) {
                    contact.shared(true);
                    if (contact.emails().size() <= 0
                        && context.shareScope() == SharedScope.INCLUDE_WITH_EMAILS)
                    {
                        continue;
                    }

                    result.add(contact);
                }
            }

            callback.completed(result);
        }
    }
}
