package ru.yandex.ace.ventura.proxy.suggest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import org.apache.http.HttpException;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.ace.ventura.AceVenturaIndexFields;
import ru.yandex.ace.ventura.proxy.AceVenturaProxy;
import ru.yandex.ace.ventura.proxy.common.AceVenturaContact;
import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.json.async.consumer.JsonAsyncTypesafeDomConsumerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.search.request.util.SearchRequestText;
import ru.yandex.search.rules.pure.SearchRule;
import ru.yandex.search.rules.pure.providers.RequestProvider;

public class AceVenturaContactsSuggestRule
    <T extends RequestProvider & AceVenturaSuggestContextProvider>
    implements SearchRule<T, List<AceVenturaContact>>
{
    private static final Collection<String> SEARCH_FIELDS =
        Collections.singleton(AceVenturaIndexFields.NAMES);

    private final AceVenturaProxy proxy;

    public AceVenturaContactsSuggestRule(final AceVenturaProxy proxy) {
        this.proxy = proxy;
    }

    public AceVenturaProxy proxy() {
        return proxy;
    }

    @Override
    public void execute(
    final T input,
    final FutureCallback<? super List<AceVenturaContact>> callback)
        throws HttpException
    {
        AceVenturaSuggestContext context = input.searchContext();

        SearchRequestText request = SearchRequestText.parseSuggest(
            input.request(),
            context.locale());

        StringBuilder textSb = new StringBuilder();

        textSb.append('(');

        if (request.hasWords()) {
            request.fieldsQuery(textSb, SEARCH_FIELDS);
        } else {
            textSb.append(AceVenturaIndexFields.UID);
            textSb.append(':');
            textSb.append(context.prefix().uid());
        }

        if (context.onlyIfhasPhone()) {
            textSb.append(" AND ");
            textSb.append(AceVenturaIndexFields.HAS_PHONES);
            textSb.append(":true");
        }

        //request.negationsQuery(textSb, SEARCH_FIELDS);
        textSb.append(')');

        QueryConstructor query =
            new QueryConstructor(
                "/search-ace-suggest?IO_PRIO=0&json-type=dollar");

        query.append("service", context.user().service());
        query.append("text", new String(textSb));
        query.append("get", "*");
        query.append("length", context.length());
        query.append("prefix", context.user().prefix().toStringFast());
        query.append("lowercase-expanded-terms", "true");

        context.session().logger().info(
            "Contact suggest rule executed " + query.toString());
        context.proxy().parallelRequest(
            context.session(),
            context,
            new BasicAsyncRequestProducerGenerator(query.toString()),
            JsonAsyncTypesafeDomConsumerFactory.OK,
            context.contextGenerator(),
            new SuggestCallback(callback, context));
    }


    private static final class SuggestCallback
        extends AbstractFilterFutureCallback<JsonObject,
        List<AceVenturaContact>>
    {
        private final AceVenturaSuggestContext context;

        private SuggestCallback(
            final FutureCallback<? super List<AceVenturaContact>> callback,
            final AceVenturaSuggestContext context)
        {
            super(callback);
            this.context = context;
        }

        @Override
        public void completed(final JsonObject response) {
            try {
                JsonMap map = response.asMap();
                //long total = map.getLong("hitsCount");
                JsonList hits = map.getList("hitsArray");

                List<AceVenturaContact> result =
                    new ArrayList<>(hits.size());
                for (JsonObject item: hits) {
                    AceVenturaContact contact =
                        AceVenturaContact.fromLuceneResponse(
                            context.session().logger(),
                            context.prefix(),
                            context.english(),
                            item.asMap());
                    if (contact != null) {
                        result.add(contact);
                    }
                }

                callback.completed(result);
            } catch (JsonException je) {
                failed(je);
            }
        }
    }
}
