package ru.yandex.ace.ventura.proxy.suggest;

import java.util.List;
import java.util.Locale;
import java.util.Set;

import ru.yandex.ace.ventura.AceVenturaFields;
import ru.yandex.ace.ventura.proxy.AceVenturaProxyContext;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.parser.uri.QueryConstructor;
import ru.yandex.search.rules.pure.providers.RequestProvider;

public interface AceVenturaSuggestContext
    extends AceVenturaProxyContext,
    RequestProvider,
    AceVenturaSuggestContextProvider
{
    Set<String> excludeEmails();

    Set<String> fields();

    boolean onlyIfhasPhone();

    List<Long> listIdFilter();

    default void extraCondition(final StringBuilder sb) {
    }

    default boolean sortQuery(final QueryConstructor qc) throws BadRequestException {
        if (sortField() != null) {
            qc.append("sort", sortField().stored());
            return true;
        }

        return false;
    }

    AceVenturaFields sortField();

    Set<String> translits();

    default String getFields() {
        return "*";
    }

    @Override
    default Long failOverDelay() {
        return proxy().config().suggest().failoverDelay();
    }

    default boolean localityShuffle() {
        return proxy().config().suggest().localityShuffle();
    }

    default boolean english() {
        return corp() && Locale.ENGLISH.equals(locale());
    }
}
