package ru.yandex.ace.ventura.proxy.suggest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;

import ru.yandex.ace.ventura.proxy.common.AceVenturaContact;
import ru.yandex.ace.ventura.proxy.common.AceVenturaResultTag;

public class AceVenturaSuggestResult implements Consumer<AceVenturaSuggestResult> {
    private final List<AceVenturaContact> contacts;
    private final List<AceVenturaResultTag> tags;

    public AceVenturaSuggestResult() {
        this.contacts = new ArrayList<>();
        this.tags = new ArrayList<>();
    }

    public AceVenturaSuggestResult(final int capacity) {
        this.contacts = new ArrayList<>(capacity);
        this.tags = new ArrayList<>(capacity);
    }

    public void add(final AceVenturaContact contact) {
        contacts.add(contact);
    }

    public void addAll(final Collection<AceVenturaContact> contacts) {
        this.contacts.addAll(contacts);
    }

    @Override
    public void accept(final AceVenturaSuggestResult result) {
        this.contacts.addAll(result.contacts);
    }

    public List<AceVenturaContact> contacts() {
        return contacts;
    }

    public List<AceVenturaResultTag> tags() {
        return tags;
    }
}
