package ru.yandex.ace.ventura.proxy.suggest;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.apache.http.HttpException;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.ace.ventura.proxy.common.AceVenturaContact;
import ru.yandex.ace.ventura.proxy.common.AceVenturaResultTag;
import ru.yandex.search.rules.pure.SearchRule;

public class PopularDomainsFallbackSuggestRule
    implements SearchRule<AceVenturaSuggestContext, Map.Entry<Collection<AceVenturaContact>, List<AceVenturaResultTag>>>
{
    private final SearchRule<AceVenturaSuggestContext, Map.Entry<Collection<AceVenturaContact>, List<AceVenturaResultTag>>> next;

    public PopularDomainsFallbackSuggestRule(
        final SearchRule<AceVenturaSuggestContext, Map.Entry<Collection<AceVenturaContact>, List<AceVenturaResultTag>>> next)
    {
        this.next = next;
    }

    @Override
    public void execute(
        final AceVenturaSuggestContext input,
        final FutureCallback<? super Map.Entry<Collection<AceVenturaContact>, List<AceVenturaResultTag>>> callback)
        throws HttpException
    {
        next.execute(input, new PopularDomainsFallbackSuggestCallback(input, callback));
    }
}
