package ru.yandex.ace.ventura.proxy.suggest;

import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Logger;

import org.apache.http.client.protocol.HttpClientContext;

import ru.yandex.ace.ventura.AceVenturaFields;
import ru.yandex.ace.ventura.AceVenturaPrefix;
import ru.yandex.ace.ventura.proxy.AceVenturaProxy;
import ru.yandex.ace.ventura.proxy.common.SharedScope;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.nio.client.AbstractAsyncClient;
import ru.yandex.json.writer.JsonType;
import ru.yandex.parser.searchmap.User;
import ru.yandex.search.rules.pure.providers.RequestProvider;

public class ShareSuggestContext
    implements AceVenturaSuggestContext,
    RequestProvider,
    AceVenturaSuggestContextProvider
{
    private final AceVenturaSuggestContext context;
    private final List<Long> listIds;
    private final AceVenturaPrefix prefix;
    private final User user;

    public ShareSuggestContext(
        final AceVenturaSuggestContext context,
        final List<Long> listIds,
        final AceVenturaPrefix prefix)
    {
        this.context = context;
        this.listIds = listIds;
        this.prefix = prefix;
        this.user = new User(context.user().service(), prefix);
    }

    @Override
    public User user() {
        return user;
    }

    @Override
    public SharedScope shareScope() {
        return SharedScope.EXCLUDE;
    }

    @Override
    public AceVenturaFields sortField() {
        return null;
    }

    @Override
    public AceVenturaPrefix prefix() {
        return prefix;
    }

    @Override
    public int length() {
        return context.length();
    }

    @Override
    public Set<String> excludeEmails() {
        return context.excludeEmails();
    }

    @Override
    public Set<String> fields() {
        return context.fields();
    }

    @Override
    public boolean onlyIfhasPhone() {
        return context.onlyIfhasPhone();
    }

    @Override
    public List<Long> listIdFilter() {
        return listIds;
    }

    @Override
    public AceVenturaProxy proxy() {
        return context.proxy();
    }

    @Override
    public ProxySession session() {
        return context.session();
    }

    @Override
    public Supplier<? extends HttpClientContext> contextGenerator() {
        return context.contextGenerator();
    }

    @Override
    public JsonType jsonType() {
        return context.jsonType();
    }

    @Override
    public AceVenturaSuggestContext searchContext() {
        return this;
    }

    @Override
    public Long minPos() {
        return context.minPos();
    }

    @Override
    public AbstractAsyncClient<?> client() {
        return context.client();
    }

    @Override
    public Logger logger() {
        return context.logger();
    }

    @Override
    public long lagTolerance() {
        return context.lagTolerance();
    }

    @Override
    public String request() {
        return context.request();
    }

    @Override
    public Locale locale() {
        return context.locale();
    }

    @Override
    public Long failOverDelay() {
        return context.failOverDelay();
    }

    @Override
    public boolean debug() {
        return context.debug();
    }

    @Override
    public Set<String> translits() {
        return context.translits();
    }

    @Override
    public boolean corp() {
        return context.corp();
    }

    @Override
    public boolean english() {
        return context.english();
    }
}
