package ru.yandex.ace.ventura.proxy.suggest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.http.HttpException;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.ace.ventura.proxy.AceVenturaProxyContext;
import ru.yandex.ace.ventura.proxy.common.AceVenturaContact;
import ru.yandex.ace.ventura.proxy.common.AceVenturaEmail;
import ru.yandex.ace.ventura.proxy.suggest.comparator.ContactsSharedPriorityComparator;
import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.http.util.DoubleFutureCallback;
import ru.yandex.search.rules.pure.SearchRule;

public class SharedAndPersonalMergeRule<T extends AceVenturaProxyContext>
    implements SearchRule<T, Collection<AceVenturaContact>>
{
    private final SearchRule<T, List<AceVenturaContact>> sharedRule;
    private final SearchRule<T, List<AceVenturaContact>> personalRule;

    public SharedAndPersonalMergeRule(
        final SearchRule<T, List<AceVenturaContact>> sharedRule,
        final SearchRule<T, List<AceVenturaContact>> personalRule)
    {
        this.sharedRule = sharedRule;
        this.personalRule = personalRule;
    }

    @Override
    public void execute(
        final T input,
        final FutureCallback<? super Collection<AceVenturaContact>> callback)
        throws HttpException
    {
        DoubleFutureCallback<Collection<AceVenturaContact>, Collection<AceVenturaContact>> dfcb =
            new DoubleFutureCallback<>(new Callback(callback));
        personalRule.execute(input, dfcb.first());
        sharedRule.execute(input, dfcb.second());
    }

    private static class Callback
        extends AbstractFilterFutureCallback<Map.Entry<Collection<AceVenturaContact>, Collection<AceVenturaContact>>, Collection<AceVenturaContact>>
    {
        public Callback(
            final FutureCallback<? super Collection<AceVenturaContact>> callback) {
            super(callback);
        }

        @Override
        public void completed(
            final Map.Entry<Collection<AceVenturaContact>, Collection<AceVenturaContact>> entry)
        {
            if (entry.getKey().isEmpty()) {
                callback.completed(entry.getValue());
                return;
            }

            if (entry.getValue().isEmpty()) {
                callback.completed(entry.getKey());
                return;
            }
            // entry.getKey() - personal
            // entry.getValue() - shared

            // now merging
            List<AceVenturaContact> result
                = new ArrayList<>(entry.getValue().size() + entry.getKey().size());

            Map<String, AceVenturaEmail> emailsMap = new LinkedHashMap<>(entry.getValue().size());
            for (AceVenturaContact contact: entry.getValue()) {
                for (AceVenturaEmail email: contact.emails()) {
                    emailsMap.put(email.groupKey(), email);
                }
            }

            for (AceVenturaContact contact: entry.getKey()) {
                Iterator<AceVenturaEmail> iterator = contact.emails().iterator();
                while (iterator.hasNext()) {
                    AceVenturaEmail persEmail = iterator.next();
                    AceVenturaEmail sharedEmail = emailsMap.get(persEmail.groupKey());
                    if (sharedEmail != null) {
                        sharedEmail.updateLastUsage(persEmail.lastUsage());
                        iterator.remove();
                    }
                }

                if (contact.emails().size() != 0) {
                    result.add(contact);
                }
            }

            for (AceVenturaContact contact: result) {
                contact.calculateRanks();
            }

            result.sort(ContactsSharedPriorityComparator.INSTANCE);

            callback.completed(result);
        }
    }
}
